#include <CGAL/Cartesian.h>
#include <CGAL/Subdivision_method_3.h>
#include <iostream>
#include <fstream>
#include <CGAL/Polyhedron_3.h>
#include <CGAL/IO/Polyhedron_iostream.h>
#include <CGAL/Arrangement_2.h>

typedef CGAL::Cartesian<double>            Kernel;
typedef CGAL::Polyhedron_3<Kernel>         Polyhedron;

using namespace std;
using namespace CGAL;

typedef Polyhedron::Vertex_iterator     Vertex_iterator;
typedef Polyhedron::Halfedge_around_vertex_const_circulator
Halfedge_around_vertex_const_circulator;
typedef Kernel::Point_3                 Point;

int main(int argc, char** argv)
{
    if (argc!=5)
    {
        cerr << "Usage: " << argv[0] << " <filename> <lambda> <mu> <steps>\n";
        exit(-1);
    }

    const char* fn = argv[1];
    double lambda = atof(argv[2]);
    double mu = atof(argv[3]);
    int steps = atoi(argv[4]);

    ifstream input;
    ofstream output;
    input.open (fn, ifstream::in);
    output.open ("output.off", ofstream::out);

    Polyhedron mesh1, mesh2;

    input >> mesh1;
    mesh2 = mesh1;

    for (int j=0;j<steps;j++)
    {
        Vertex_iterator Vi1, Vi2;

        for (Vi1 = mesh1.vertices_begin(), Vi2 = mesh2.vertices_begin();
                Vi1 != mesh1.vertices_end();
                Vi1++, Vi2++)
        {
            int n = Vi1->vertex_degree();
            Halfedge_around_vertex_const_circulator Vo=Vi1->vertex_begin();

            double x=0,y=0,z=0;
            for ( int i=0; i<n; i++, Vo++ )
            {
                Point Vj = Vo->opposite()->vertex()->point();
                x += Vj.x();
                y += Vj.y();
                z += Vj.z();
            }

            double Delta_x = x / n - Vi1->point().x();
            double Delta_y = y / n - Vi1->point().y();
            double Delta_z = z / n - Vi1->point().z();

            Vi2->point() = Point (   Vi1->point().x() + Delta_x * lambda,
                                     Vi1->point().y() + Delta_y * lambda,
                                     Vi1->point().z() + Delta_z * lambda );
        }

        for (Vi2 = mesh2.vertices_begin(), Vi1 = mesh1.vertices_begin();
                Vi2 != mesh2.vertices_end();
                Vi2++, Vi1++)
        {
            int n = Vi2->vertex_degree();
            Halfedge_around_vertex_const_circulator Vo=Vi2->vertex_begin();

            double x=0,y=0,z=0;
            for ( int i=0; i<n; i++, Vo++ )
            {
                Point Vj = Vo->opposite()->vertex()->point();
                x += Vj.x();
                y += Vj.y();
                z += Vj.z();
            }

            double Delta_x = x / n - Vi2->point().x();
            double Delta_y = y / n - Vi2->point().y();
            double Delta_z = z / n - Vi2->point().z();

            Vi1->point() = Point (   Vi2->point().x() + Delta_x * mu,
                                     Vi2->point().y() + Delta_y * mu,
                                     Vi2->point().z() + Delta_z * mu );
        }
    }

    output << mesh1;

    input.close();
    output.close();

    return 0;
}

